package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.PagedList
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption
import com.ekoapp.core.utils.requiredNonNull
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import io.reactivex.Flowable

internal class GetUserPagedListUseCase {

    fun execute(keyword: String? = null, sortBy: AmityUserSortOption): Flowable<PagedList<AmityUser>> {
        return UserRepository().getUserPagedList(requiredNonNull(keyword), sortBy)
    }
}