package com.ekoapp.ekosdk.internal.usecase.user

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.core.domain.user.UserComposerUseCase
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.amity.socialcloud.sdk.core.user.AmityUserSortOption
import com.ekoapp.core.utils.requiredNonNull
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetUserPagingDataUseCase {

    fun execute(keyword: String?, sortBy: AmityUserSortOption): Flowable<PagingData<AmityUser>> {
        return UserRepository().getUserPagingData(keyword, sortBy)
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) {
                    UserComposerUseCase().execute(it)
                }
            }
    }
}