package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.core.user.AmityUser
import com.ekoapp.ekosdk.internal.constants.USER_ID
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.ekoapp.ekosdk.internal.repository.user.UserUpdateOption
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Single

internal class UpdateUserUseCase {

    fun execute(userId: String, option: UserUpdateOption): Single<AmityUser> {
        EkoPreconditions.checkValidParameter(userId, USER_ID)
        return UserRepository().updateUser(userId, option)
    }

}