package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.core.domain.user.UserComposerUseCase
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.ekoapp.ekosdk.AmityObjectRepository
import com.ekoapp.ekosdk.UserEntity
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class UserLiveObjectUseCase : LiveObjectUseCase<UserEntity, AmityUser>() {

    override fun createRepository(): AmityObjectRepository<UserEntity, AmityUser> = UserRepository()

    override fun composeModel(model: AmityUser): AmityUser = UserComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.USER
}