package com.ekoapp.ekosdk.internal.util;

import android.content.Context;

import io.reactivex.Flowable;
import io.reactivex.processors.AsyncProcessor;

import static com.google.common.base.Preconditions.checkNotNull;

public class AppContext {

    private static final AsyncProcessor<Context> APP_CONTEXT = AsyncProcessor.create();


    public static synchronized void init(Context context) {
        checkNotNull(context, "context is null");
        APP_CONTEXT.onNext(context.getApplicationContext());
        APP_CONTEXT.onComplete();
    }

    public static Flowable<Context> getFlowable() {
        return APP_CONTEXT.hide();
    }

    public static Context get() {
        return APP_CONTEXT.getValue();
    }


    private AppContext() { /* NO INSTANCE */ }
}
