package com.ekoapp.ekosdk.internal.util;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

public class EkoPreconditions {

    public static String checkValidId(String stringToCheck, String name) {
        checkNotNull(stringToCheck, String.format("%s is null", name));
        checkArgument(!stringToCheck.isEmpty(), String.format("%s is empty: \"%s\"", name, stringToCheck));
        return stringToCheck;
    }

    public static Object checkValidParameter(Object obj, String name) {
        checkNotNull(obj, String.format("%s is null", name));
        return obj;
    }
}
