package com.ekoapp.ekosdk.internal.util

import io.reactivex.rxjava3.core.BackpressureStrategy
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.subjects.PublishSubject

object Rx3Amity {

    /**
     * safeMergeFlowableWithCompletable merges a flowable publisher and completable publisher without caring
     * completable publisher's onComplete result. Basically, a flowable from
     * flowablePublisher emits normally but, completablePublisher emits onError event only.
     * @param flowablePublisher - flowable publisher to observe onNext/onError
     * @param completablePublisher - completable publisher to observe onError
     * @return Flowable of <T>
     */
    fun <T : Any> safeMergeFlowableWithCompletable(
        flowablePublisher: Flowable<T>,
        completablePublisher: Completable
    ): Flowable<T> {
        val subject = PublishSubject.create<T>()
        val completableDisposable = completablePublisher
            .doOnError { subject.onError(it) }
            .subscribe()
        val flowableDisposable = flowablePublisher
            .doOnNext { subject.onNext(it) }
            .doOnError { subject.onError(it) }
            .subscribe()
        return subject.doOnDispose {
            completableDisposable.dispose()
            flowableDisposable.dispose()
        }.toFlowable(BackpressureStrategy.LATEST)
    }
}