package com.amity.socialcloud.sdk.core.error

import com.google.common.base.Strings

class AmityAsyncError private constructor(val throwable: Throwable, message: String) {
    val message: String

    companion object {
        @JvmStatic
        fun from(throwable: Throwable, message: String): AmityAsyncError {
            return AmityAsyncError(throwable, message)
        }
    }

    init {
        this.message = Strings.nullToEmpty(message)
    }
}