package com.amity.socialcloud.sdk.chat.message

import com.amity.socialcloud.sdk.core.AmityTags
import com.google.gson.JsonObject

class AmityCustomMessageCreator private constructor(
    channelId: String,
    parentId: String?,
    tags: AmityTags,
    private val data: JsonObject
) : AmityMessageCreator(
    channelId = channelId,
    parentId = parentId,
    tags = tags
) {

    override fun getData(): JsonObject {
        return data
    }

    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.CUSTOM
    }

    class Builder {
        private lateinit var channelId: String
        private var parentId: String? = null
        private lateinit var data: JsonObject
        private var tags: AmityTags = AmityTags()

        internal fun channelId(channelId: String): Builder {
            return apply { this.channelId = channelId }
        }

        internal fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }

        internal fun data(data: JsonObject): Builder {
            return apply { this.data = data }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityCustomMessageCreator {
            return AmityCustomMessageCreator(channelId, parentId, tags, data)
        }
    }

}