package com.amity.socialcloud.sdk.chat.message

import android.net.Uri
import com.amity.socialcloud.sdk.core.AmityTags
import com.google.gson.JsonObject

class AmityImageMessageCreator(
    channelId: String,
    parentId: String?,
    tags: AmityTags,
    private val uri: Uri,
    private val caption: String?
) : AmityMessageCreator(
    channelId = channelId,
    parentId = parentId,
    tags = tags,
    fileUri = uri
) {

    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.IMAGE
    }

    override fun getData(): JsonObject {
        val data = JsonObject()
        data.addProperty("caption", caption ?: "")
        return data
    }

    class Builder {
        private lateinit var channelId: String
        private var parentId: String? = null
        private var tags: AmityTags = AmityTags()
        private lateinit var uri: Uri
        private var caption: String? = null
        private var isFullImage: Boolean = false

        internal fun channelId(channelId: String): Builder {
            return apply { this.channelId = channelId }
        }

        internal fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }

        internal fun uri(uri: Uri): Builder {
            return apply { this.uri = uri }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun caption(caption: String): Builder {
            return apply { this.caption = caption }
        }

        fun isFullImage(isFullImage: Boolean): Builder {
            return apply { this.isFullImage = isFullImage }
        }

        fun build(): AmityImageMessageCreator {
            return AmityImageMessageCreator(channelId, parentId, tags, uri, caption)
        }
    }

}