package com.amity.socialcloud.sdk.chat.message

import android.net.Uri
import com.google.gson.JsonObject

class AmityMessageCreateTypeSelector(private val channelId: String, private val parentId: String?) {
    fun text(text: String): AmityTextMessageCreator.Builder {
        return AmityTextMessageCreator.Builder()
                .channelId(channelId)
                .parentId(parentId)
                .text(text)
    }

    fun file(uri: Uri): AmityFileMessageCreator.Builder {
        return AmityFileMessageCreator.Builder()
                .channelId(channelId)
                .parentId(parentId)
                .uri(uri)
    }

    fun image(uri: Uri): AmityImageMessageCreator.Builder {
        return AmityImageMessageCreator.Builder()
                .channelId(channelId)
                .parentId(parentId)
                .uri(uri)
    }

    fun audio(uri: Uri): AmityAudioMessageCreator.Builder {
        return AmityAudioMessageCreator.Builder()
                .channelId(channelId)
                .parentId(parentId)
                .uri(uri)
    }
    
    fun video(uri: Uri): AmityVideoMessageCreator.Builder {
        return AmityVideoMessageCreator.Builder()
                .channelId(channelId)
                .parentId(parentId)
                .uri(uri)
    }

    fun custom(data: JsonObject): AmityCustomMessageCreator.Builder {
        return AmityCustomMessageCreator.Builder()
                .channelId(channelId)
                .parentId(parentId)
                .data(data)
    }

}