package com.amity.socialcloud.sdk.chat.message

import android.net.Uri
import com.amity.socialcloud.sdk.chat.domain.message.MessageCreateUseCase
import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.ekoapp.core.utils.toV2
import com.google.gson.JsonObject
import io.reactivex.Completable

abstract class AmityMessageCreator internal constructor(
    private val channelId: String,
    private val parentId: String?,
    private val metadata: JsonObject? = null,
    private val tags: AmityTags = AmityTags(),
    private val mentionees: List<AmityMentioneeTarget> = emptyList(),
    private val fileUri: Uri? = null,
) {

    fun getTags(): AmityTags {
        return tags
    }

    abstract fun getData(): JsonObject

    abstract fun getDataType(): AmityMessage.DataType

    fun send(): Completable {
        return MessageCreateUseCase().execute(
            channelId = channelId,
            parentId = parentId,
            type = getDataType().apiKey,
            fileUri = fileUri,
            data = getData(),
            tags = tags,
            metadata = metadata,
            mentionees = mentionees
        ).toV2()
    }

}