package com.amity.socialcloud.sdk.chat.message

import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject

class AmityTextMessageCreator private constructor(
    channelId: String,
    parentId: String?,
    metadata: JsonObject?,
    tags: AmityTags,
    mentionees: List<AmityMentioneeTarget>,
    private val text: String
) : AmityMessageCreator(channelId, parentId, metadata, tags, mentionees) {

    override fun getData(): JsonObject {
        val data = JsonObject()
        data.addProperty(getDataType().apiKey, text)
        return data
    }

    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.TEXT
    }

    class Builder {
        private lateinit var channelId: String
        private var parentId: String? = null
        private lateinit var text: String
        private var metadata: JsonObject? = null
        private var tags: AmityTags = AmityTags()
        private var mentionees: MutableList<AmityMentioneeTarget> = mutableListOf()

        internal fun channelId(channelId: String): Builder {
            this.channelId = channelId
            return this
        }

        internal fun parentId(parentId: String?): Builder {
            this.parentId = parentId
            return this
        }

        internal fun text(text: String): Builder {
            this.text = text
            return this
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun tags(tags: AmityTags): Builder {
            this.tags = tags
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            mentionees.add(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun mentionChannel(): Builder {
            mentionees.add(AmityMentioneeTarget(AmityMentionType.CHANNEL.apiKey))
            return this
        }

        fun build(): AmityTextMessageCreator {
            return AmityTextMessageCreator(channelId, parentId, metadata, tags, mentionees, text)
        }
    }

}