package com.amity.socialcloud.sdk.chat.message

import android.net.Uri
import com.amity.socialcloud.sdk.core.AmityTags
import com.google.gson.JsonObject

class AmityVideoMessageCreator(
    channelId: String,
    parentId: String?,
    tags: AmityTags,
    private val uri: Uri,
) : AmityMessageCreator(
    channelId = channelId,
    parentId = parentId,
    tags = tags,
    fileUri = uri
) {
    
    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.VIDEO
    }
    
    override fun getData(): JsonObject {
        return JsonObject()
    }

    class Builder {
        private lateinit var channelId: String
        private var parentId: String? = null
        private var tags: AmityTags = AmityTags()
        private lateinit var uri: Uri

        internal fun channelId(channelId: String): Builder {
            return apply { this.channelId = channelId }
        }

        internal fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }

        internal fun uri(uri: Uri): Builder {
            return apply { this.uri = uri }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityVideoMessageCreator {
            return AmityVideoMessageCreator(channelId, parentId, tags, uri)
        }
    }

}