package com.amity.socialcloud.sdk.chat.message

import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject


class AmityCustomTextMessageEditor internal constructor(
    messageId: String,
    private val data: JsonObject?,
    private val tags: AmityTags?
) : AmityMessageEditor(messageId) {


    override fun getData(): JsonObject? {
        return data
    }

    override fun getTags(): AmityTags? {
        return tags
    }

    override fun getMetadata(): JsonObject? {
        return null
    }

    override fun getMentionees(): List<AmityMentioneeTarget>? {
        return null
    }

    class Builder(private val messageId: String) {

        private var data: JsonObject? = null
        private var tags: AmityTags? = null

        fun data(data: JsonObject): Builder {
            return apply {
                this.data = data
            }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityCustomTextMessageEditor {
            return AmityCustomTextMessageEditor(messageId, data, tags)
        }

    }

}