package com.amity.socialcloud.sdk.chat.message

import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.ekosdk.internal.usecase.message.MessageUpdateUseCase
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.ekoapp.core.utils.toV2
import com.google.gson.JsonObject
import io.reactivex.Completable

abstract class AmityMessageEditor(private val messageId: String) {
    internal abstract fun getData(): JsonObject?
    internal abstract fun getTags(): AmityTags?
    internal abstract fun getMetadata(): JsonObject?
    internal abstract fun getMentionees(): List<AmityMentioneeTarget>?

    fun apply(): Completable {
        return MessageUpdateUseCase().execute(
            messageId,
            getData(),
            getTags(),
            getMetadata(),
            getMentionees()
        ).toV2()
    }
}