package com.ekoapp.ekosdk.message.flag

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.report.AmityFlagger
import com.ekoapp.ekosdk.internal.usecase.message.FlagMessageUseCase
import com.ekoapp.ekosdk.internal.usecase.message.UnFlagMessageUseCase
import io.reactivex.Completable

class AmityMessageFlagger internal constructor(private val messageId: String) : AmityFlagger() {

    fun flag(): Completable {
        return FlagMessageUseCase().execute(messageId).toV2()
    }

    fun unflag(): Completable {
        return UnFlagMessageUseCase().execute(messageId).toV2()
    }

}