package com.ekoapp.ekosdk.permission

import com.amity.socialcloud.sdk.core.permission.AmityPermission
import com.amity.socialcloud.sdk.core.permission.AmityPermissions
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.google.common.base.Predicates
import com.google.common.collect.FluentIterable
import io.reactivex.Flowable

class PermissionRepository {

    fun getGlobalPermission(userId: String): Flowable<List<AmityPermission>> {
        return UserDatabase.get().userDao().getById(userId).toV2()
                .map { it.permissions?.let(this::mapToEkoPermissionList) }
    }

    fun getChannelPermission(channelId: String, userId: String): Flowable<List<AmityPermission>> {
        return UserDatabase.get().channelMembershipDao().getByChannelIdAndUserId(channelId, userId).toV2()
                .map { it.permissions?.let(this::mapToEkoPermissionList) }
    }

    fun getCommunityPermission(communityId: String, userId: String): Flowable<List<AmityPermission>> {
        return UserDatabase.get().communityMembershipDao().getById(communityId, userId)
                .map { it.permissions?.let(this::mapToEkoPermissionList) }
    }

    private fun mapToEkoPermissionList(permissions: AmityPermissions): List<AmityPermission> {
        return FluentIterable
                .from(permissions)
                .transform { permission ->
                    if (AmityPermission.values().any { it.value == permission }) {
                        permission?.let { AmityPermission.valueOf(it) }
                    } else null
                }
                .filter(Predicates.notNull())
                .toList()
    }

}