package com.amity.socialcloud.sdk.social.post

import com.amity.socialcloud.sdk.social.feed.AmityPoll
import com.amity.socialcloud.sdk.social.feed.AmityPollAnswer
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.post.PollCreateUseCase
import io.reactivex.Single

class AmityPollBuilder private constructor(
    private val question: String,
    private val answers: List<AmityPollAnswer.Data>,
    private val answerType: AmityPoll.AnswerType,
    private val closedIn: Long?
) {

    fun create(): Single<String> {
        return PollCreateUseCase().execute(
            question = question,
            answers = answers,
            answerType = answerType.apiKey,
            closedIn = closedIn
        ).toV2()
    }

    class Builder(private val question: String) {

        private var answers: List<AmityPollAnswer.Data> = listOf()
        private var answerType: AmityPoll.AnswerType = AmityPoll.AnswerType.SINGLE
        private var closedIn: Long? = null

        fun answers(answers: List<AmityPollAnswer.Data>): Builder {
            this.answers = answers
            return this
        }

        fun answerType(answerType: AmityPoll.AnswerType): Builder {
            this.answerType = answerType
            return this
        }

        fun closedIn(closedIn: Long): Builder {
            this.closedIn = closedIn
            return this
        }

        fun build(): AmityPollBuilder {
            return AmityPollBuilder(question, answers, answerType, closedIn)
        }
    }
}