package com.amity.socialcloud.sdk.social.post

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import com.amity.socialcloud.sdk.social.feed.AmityCommunityFeedSortOption
import com.amity.socialcloud.sdk.social.feed.AmityFeedType
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.ekoapp.ekosdk.internal.usecase.post.GetCommunityPostPagingDataUseCase
import io.reactivex.Flowable

class AmityCommunityPostQuery(
    private val communityId: String,
    private val sortOption: AmityCommunityFeedSortOption,
    private val isDeleted: Boolean?,
    private val feedType: AmityFeedType,
    private val postTypes: List<AmityPost.DataType>
) {

    @ExperimentalPagingApi
    fun getPagingData(): Flowable<PagingData<AmityPost>> {
        return GetCommunityPostPagingDataUseCase().execute(
            communityId = communityId,
            sortOption = sortOption,
            isDeleted = isDeleted,
            feedType = feedType,
            postTypes = postTypes
        )
    }

    class Builder internal constructor(private val communityId: String) {

        private var sortOption: AmityCommunityFeedSortOption =
            AmityCommunityFeedSortOption.LAST_CREATED
        private var isDeleted: Boolean? = null
        private var feedType: AmityFeedType = AmityFeedType.PUBLISHED
        private var postTypes: List<AmityPost.DataType> = listOf()

        fun sortBy(sortOption: AmityCommunityFeedSortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            this.isDeleted = includeDeleted
            return this
        }

        fun feedType(feedType: AmityFeedType): Builder {
            return apply { this.feedType = feedType }
        }

        fun types(postTypes: List<AmityPost.DataType>): Builder {
            return apply { this.postTypes = postTypes }
        }

        fun build(): AmityCommunityPostQuery {
            return AmityCommunityPostQuery(
                communityId = communityId,
                sortOption = sortOption,
                isDeleted = isDeleted,
                feedType = feedType,
                postTypes = postTypes
            )
        }
    }

}