package com.amity.socialcloud.sdk.social.post

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagingData
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.amity.socialcloud.sdk.social.feed.AmityUserFeedSortOption
import com.ekoapp.ekosdk.internal.usecase.post.GetUserPostPagingDataUseCase
import io.reactivex.Flowable

class AmityUserPostQuery(
    private val userId: String,
    private val sortOption: AmityUserFeedSortOption,
    private val isDeleted: Boolean?,
    private val postTypes: List<AmityPost.DataType>
) {

    @ExperimentalPagingApi
    fun getPagingData(): Flowable<PagingData<AmityPost>> {
        return GetUserPostPagingDataUseCase().execute(
            userId = userId,
            sortOption = sortOption,
            isDeleted = isDeleted,
            postTypes = postTypes
        )
    }


    class Builder internal constructor(private val userId: String) {

        private var sortOption: AmityUserFeedSortOption = AmityUserFeedSortOption.LAST_CREATED
        private var isDeleted: Boolean? = null
        private var postTypes: List<AmityPost.DataType> = listOf()

        fun sortBy(sortOption: AmityUserFeedSortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            this.isDeleted = includeDeleted
            return this
        }

        fun types(postTypes: List<AmityPost.DataType>): Builder {
            return apply { this.postTypes = postTypes }
        }

        fun build(): AmityUserPostQuery {
            return AmityUserPostQuery(
                userId = userId,
                sortOption = sortOption,
                isDeleted = isDeleted,
                postTypes = postTypes
            )
        }
    }

}