package com.amity.socialcloud.sdk.social.comment

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.comment.CommentReactionListQueryUseCase
import com.ekoapp.ekosdk.internal.usecase.post.ReactionPagingDataUseCase
import io.reactivex.Flowable

class AmityCommentReactionQuery private constructor(private val commentId: String,
                                                    private val reactionName: String) {

    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityReaction>> {
        return CommentReactionListQueryUseCase().execute(commentId, reactionName).toV2()
    }

    fun getPagingData(): Flowable<PagingData<AmityReaction>> {
        return ReactionPagingDataUseCase().execute(
            referenceType = ReactionReferenceType.COMMENT,
            referenceId = commentId,
            reactionName = reactionName
        ).toV2()
    }

    class Builder internal constructor(private var commentId: String) {

        private var reactionName: String = ""

        fun reactionName(reactionName: String): Builder {
            return apply { this.reactionName = reactionName }
        }

        fun build(): AmityCommentReactionQuery {
            return AmityCommentReactionQuery(commentId, reactionName)
        }
    }

}