package com.amity.socialcloud.sdk.core.reaction

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.message.MessageReactionListQueryUseCase
import com.ekoapp.ekosdk.internal.usecase.post.ReactionPagingDataUseCase
import io.reactivex.Flowable

class AmityMessageReactionQuery private constructor(private val messageId: String,
                                                    private val reactionName: String) {

    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityReaction>> {
        return MessageReactionListQueryUseCase().execute(messageId, reactionName).toV2()
    }

    fun getPagingData(): Flowable<PagingData<AmityReaction>> {
        return ReactionPagingDataUseCase().execute(
            referenceType = ReactionReferenceType.MESSAGE,
            referenceId = messageId,
            reactionName = reactionName
        ).toV2()
    }

    class Builder internal constructor(private val messageId: String) {

        private var reactionName: String = ""

        fun reactionName(reactionName: String): Builder {
            return apply { this.reactionName = reactionName }
        }

        fun build(): AmityMessageReactionQuery {
            return AmityMessageReactionQuery(messageId, reactionName)
        }
    }

}