package com.amity.socialcloud.sdk.core.reaction

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.post.PostReactionListQueryUseCase
import com.ekoapp.ekosdk.internal.usecase.post.ReactionPagingDataUseCase
import io.reactivex.Flowable

class AmityPostReactionQuery private constructor(
    private val postId: String,
    private val reactionName: String?
) {

    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityReaction>> {
        return PostReactionListQueryUseCase().execute(postId, reactionName).toV2()
    }

    fun getPagingData(): Flowable<PagingData<AmityReaction>> {
        return ReactionPagingDataUseCase().execute(ReactionReferenceType.POST, postId, reactionName).toV2()
    }

    class Builder internal constructor(private val postId: String) {

        private var reactionName: String? = null

        fun reactionName(reactionName: String): Builder {
            return apply { this.reactionName = reactionName }
        }

        fun build(): AmityPostReactionQuery {
            return AmityPostReactionQuery(postId, reactionName)
        }
    }

}