package com.amity.socialcloud.sdk.core.reaction

import com.amity.socialcloud.sdk.core.domain.reaction.ReactionAddUseCase
import com.amity.socialcloud.sdk.core.domain.reaction.ReactionRemoveUseCase
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity
import io.reactivex.Completable

class AmityReactor internal constructor(private val referenceType: ReactionReferenceType,
                                        private val referenceId: String) {

    fun addReaction(reactionName: String) : Completable {
        return ReactionAddUseCase().execute(referenceType, referenceId, reactionName).toV2()
    }

    fun removeReaction(reactionName: String): Completable {
        return ReactionRemoveUseCase().execute(referenceType, referenceId, reactionName).toV2()
    }

}