package com.amity.socialcloud.sdk.video.stream

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
class AmityRecordingData(private val recordingData: JsonObject? = null) : Parcelable {

    enum class Format {
        MP4, FLV, M3U8;

        val apiString: String
            get() = name.toLowerCase()
    }

    fun getUrl(format: Format): String? {
        return recordingData?.get(format.apiString)?.asJsonObject?.get("url")?.asString
    }
}