package com.amity.socialcloud.sdk.video.stream

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.ekoapp.ekosdk.JsonArrayParceler
import com.amity.socialcloud.sdk.video.stream.AmityWatcherData
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
@TypeParceler<JsonArray?, JsonArrayParceler>
data class AmityStream internal constructor(private val streamId: String,
                                            private val status: Status = Status.IDLE,
                                            private val title: String?,
                                            private val description: String?,
                                            private val resolution: String?,
                                            private val thumbnailImage: AmityImage?,
                                            private val watcherData: JsonObject?,
                                            private val broadcasterData: JsonObject?,
                                            private val recordings: JsonArray?,
                                            private val user: AmityUser?,
                                            private val metadata: JsonObject?,
                                            private val isDeleted: Boolean,
                                            private val createdAt: DateTime?,
                                            private val updatedAt: DateTime?) : Parcelable, ReactorObject {

    fun getStreamId(): String {
        return streamId
    }

    fun getStatus(): Status {
        return status
    }

    fun getTitle(): String? {
        return title
    }

    fun getDescription(): String? {
        return description
    }

    fun getResolution(): String? {
        return resolution
    }

    fun getUser(): AmityUser? {
        return user
    }

    fun getThumbnailImage(): AmityImage? {
        return thumbnailImage
    }

    fun getMetaData(): JsonObject? {
        return metadata
    }

    fun getCreatedAt(): DateTime? {
        return createdAt
    }

    fun getUpdatedAt(): DateTime? {
        return updatedAt
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    fun getWatcherData(): AmityWatcherData? {
        watcherData?.let {
            return AmityWatcherData(watcherData)
        } ?: kotlin.run {
            return null
        }
    }

    fun getBroadcasterData(): AmityBroadcasterData? {
        broadcasterData?.let {
            return AmityBroadcasterData(broadcasterData)
        } ?: kotlin.run {
            return null
        }
    }

    fun getRecordings(): List<AmityRecordingData?> {
        recordings?.let {
            val recordingDataList = arrayListOf<AmityRecordingData>()
            it.forEach { jsonElement ->
                if (jsonElement is JsonObject) {
                    recordingDataList.add(AmityRecordingData(jsonElement))
                }
            }
            return recordingDataList
        } ?: kotlin.run {
            return listOf()
        }
    }

    enum class Status(val apiKey: String) {
        IDLE("idle"),
        LIVE("live"),
        ENDED("ended"),
        RECORDED("recorded");

        companion object {
            fun enumOf(value: String?): Status {
                return values().find { it.apiKey == value } ?: IDLE
            }
        }
    }
    
    override fun updatedAt(): DateTime? {
        return updatedAt
    }
    
    override fun uniqueId(): String {
        return streamId
    }
}