package com.amity.socialcloud.sdk.video.stream

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.stream.StreamQueryPagingDataUseCase
import com.ekoapp.ekosdk.internal.usecase.stream.StreamQueryUseCase
import io.reactivex.Flowable

class AmityStreamQuery constructor(private val statuses: Array<AmityStream.Status>) {
    
    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityStream>> {
        return StreamQueryUseCase().execute(statuses).toV2()
    }
    
    fun getPagingData(): Flowable<PagingData<AmityStream>> {
        return StreamQueryPagingDataUseCase().execute(statuses).toV2()
    }

    class Builder internal constructor() {

        private var statuses = arrayOf(AmityStream.Status.IDLE)

        fun setStatus(statuses: Array<AmityStream.Status>): Builder {
            this.statuses = statuses
            return this
        }

        fun build(): AmityStreamQuery {
            return AmityStreamQuery(statuses = statuses)
        }
    }
}