package  com.amity.socialcloud.sdk.core.user

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.events.AmityTopic
import com.amity.socialcloud.sdk.core.events.AmityTopicSubscription
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.core.flag.AmityUserFlagger
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.core.events.user.AmityUserEvents
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler
import org.amity.types.ObjectId
import org.joda.time.DateTime


@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityUser internal constructor(
        internal val mid: String,
        private val userId: String = ObjectId.get().toHexString(),
        private val displayName: String? = null,
        private val roles: AmityRoles? = null,
        private val flagCount: Int = 0,
        private val metadata: JsonObject? = null,
        internal val avatarFileId: String?,
        internal var avatar: AmityImage? = null,
        private val avatarCustomUrl: String?,
        private val description: String,
        internal var isFlaggedByMe: Boolean = false,
        private val createdAt: DateTime,
        private val updatedAt: DateTime,
        private val isGlobalBan: Boolean,
        private val isDeleted: Boolean,
        internal val path: String
): Parcelable, ReactorObject {

    fun getUserId(): String {
        return userId
    }

    fun getDisplayName(): String? {
        return displayName
    }

    fun getRoles(): AmityRoles {
        return roles ?: AmityRoles()
    }

    fun getFlagCount(): Int {
        return flagCount
    }

    fun getMetadata(): JsonObject? {
        return metadata
    }

    fun getAvatar(): AmityImage? {
        return avatar
    }

    fun getAvatarCustomUrl(): String? {
        return avatarCustomUrl
    }

    fun getDescription(): String {
        return description
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    fun isFlaggedByMe(): Boolean {
        return isFlaggedByMe
    }

    fun report(): AmityUserFlagger {
        return AmityUserFlagger(userId)
    }

    fun isGlobalBan(): Boolean {
        return isGlobalBan
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    override fun updatedAt(): DateTime? {
        return updatedAt
    }

    override fun uniqueId(): String {
        return userId
    }

    fun subscription(events: AmityUserEvents): AmityTopicSubscription {
        return AmityTopicSubscription(AmityTopic.USER(this, events))
    }

}
