package  com.amity.socialcloud.sdk.core.flag

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.report.AmityFlagType
import com.ekoapp.ekosdk.internal.report.AmityFlagger
import com.ekoapp.ekosdk.internal.usecase.user.FlagUserUseCase
import com.ekoapp.ekosdk.internal.usecase.user.UnFlagUserUseCase
import io.reactivex.Completable

class AmityUserFlagger internal constructor(private val userId: String) : AmityFlagger() {


    private fun flag(vararg flagTypes: AmityFlagType): Completable {
        return FlagUserUseCase().execute(userId, *flagTypes).toV2()
    }

    private fun unflag(vararg flagTypes: AmityFlagType): Completable {
        return UnFlagUserUseCase().execute(userId, *flagTypes).toV2()
    }

    fun flag(): Completable {
        return flag(AmityFlagType.HATE_SPEECH)
    }

    fun unflag(): Completable {
        return unflag(AmityFlagType.HATE_SPEECH)
    }

}