package com.amity.socialcloud.sdk.core.user

enum class AmityFollowStatus(val apiKey: String) {
    PENDING("pending"),
    ACCEPTED("accepted"),
    NONE("none");

    companion object {
        fun enumOf(value: String?): AmityFollowStatus {
            return values().find { it.apiKey == value } ?: NONE
        }
    }
}