package com.amity.socialcloud.sdk.core.user

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.GetMyFollowersPagedListDataUseCase
import com.ekoapp.ekosdk.internal.usecase.user.GetMyFollowersPagingDataUseCase
import io.reactivex.Flowable

class AmityMyFollowersQuery private constructor(private val status: AmityFollowStatusFilter) {

    fun getPagingData(): Flowable<PagingData<AmityFollowRelationship>> {
        return GetMyFollowersPagingDataUseCase().execute(status = status).toV2()
    }

    fun query(): Flowable<PagedList<AmityFollowRelationship>> {
        return GetMyFollowersPagedListDataUseCase().execute(status = status).toV2()
    }

    class Builder internal constructor() {
        private var status: AmityFollowStatusFilter = AmityFollowStatusFilter.ALL

        fun status(status: AmityFollowStatusFilter): Builder {
            this.status = status
            return this
        }

        fun build(): AmityMyFollowersQuery {
            return AmityMyFollowersQuery(status)
        }
    }
}