package com.amity.socialcloud.sdk.core.user

import com.amity.socialcloud.sdk.AmityCoreClient
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.*
import io.reactivex.Completable
import io.reactivex.Flowable

class AmityMyUserRelationship internal constructor() {

    fun accept(userId: String): Completable {
        return AcceptFollowUseCase().execute(userId).toV2()
    }

    fun decline(userId: String): Completable {
        return DeclineFollowUseCase().execute(userId).toV2()
    }

    fun removeFollower(userId: String): Completable {
        return RemoveFollowerUseCase().execute(userId).toV2()
    }

    fun unfollow(userId: String): Completable {
        return UnfollowUseCase().execute(userId).toV2()
    }

    fun getFollowings(): AmityMyFollowingsQuery.Builder {
        return AmityMyFollowingsQuery.Builder()
    }

    fun getFollowers(): AmityMyFollowersQuery.Builder {
        return AmityMyFollowersQuery.Builder()
    }

    fun getFollowInfo(): Flowable<AmityMyFollowInfo> {
        return MyFollowLiveObjectUseCase().execute(AmityCoreClient.getUserId()).toV2()
    }

}