package  com.amity.socialcloud.sdk.core.user

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityUserFollowInfo internal constructor(
        private val status: AmityFollowStatus = AmityFollowStatus.NONE,
        private val followingCount: Int = 0,
        private val followerCount: Int = 0
) : Parcelable {

    fun getStatus(): AmityFollowStatus {
        return status
    }

    fun getFollowerCount(): Int {
        return followerCount
    }

    fun getFollowingCount(): Int {
        return followingCount
    }
}
