package com.amity.socialcloud.sdk.core.user

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.GetUserFollowersPagedListDataUseCase
import com.ekoapp.ekosdk.internal.usecase.user.GetUserFollowersPagingDataUseCase
import io.reactivex.Flowable

class AmityUserFollowersQuery private constructor(private val userId: String) {

    @ExperimentalPagingApi
    fun getPagingData(): Flowable<PagingData<AmityFollowRelationship>> {
        return GetUserFollowersPagingDataUseCase().execute(userId = userId).toV2()
    }

    fun query(): Flowable<PagedList<AmityFollowRelationship>> {
        return GetUserFollowersPagedListDataUseCase().execute(userId = userId).toV2()
    }

    class Builder internal constructor(private val userId: String) {

        fun build(): AmityUserFollowersQuery {
            return AmityUserFollowersQuery(userId)
        }
    }
}