package com.amity.socialcloud.sdk.core.user

import androidx.paging.ExperimentalPagingApi
import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.GetUserFollowingsPagedListDataUseCase
import com.ekoapp.ekosdk.internal.usecase.user.GetUserFollowingsPagingDataUseCase
import io.reactivex.Flowable

class AmityUserFollowingsQuery private constructor(private val userId: String) {

    @ExperimentalPagingApi
    fun getPagingData(): Flowable<PagingData<AmityFollowRelationship>> {
        return GetUserFollowingsPagingDataUseCase().execute(userId = userId).toV2()
    }

    fun query(): Flowable<PagedList<AmityFollowRelationship>> {
        return GetUserFollowingsPagedListDataUseCase().execute(userId = userId).toV2()
    }

    class Builder internal constructor(private val userId: String) {

        fun build(): AmityUserFollowingsQuery {
            return AmityUserFollowingsQuery(userId)
        }
    }
}