package com.amity.socialcloud.sdk.core.user

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.GetUserFollowInfoUseCase
import com.ekoapp.ekosdk.internal.usecase.user.UserFollowRequestUseCase
import io.reactivex.Flowable
import io.reactivex.Single

class AmityUserRelationship(private val userId: String) {

    fun follow(): Single<AmityFollowStatus> {
        return UserFollowRequestUseCase().execute(userId).toV2()
    }

    fun getFollowings(): AmityUserFollowingsQuery.Builder {
        return AmityUserFollowingsQuery.Builder(userId)
    }

    fun getFollowers(): AmityUserFollowersQuery.Builder {
        return AmityUserFollowersQuery.Builder(userId)
    }

    fun getFollowInfo(): Flowable<AmityUserFollowInfo> {
        return GetUserFollowInfoUseCase().execute(userId).toV2()
    }

}