package com.amity.socialcloud.sdk.core.user

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.GetUserNotificationUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.UpdateUserNotificationUseCase
import io.reactivex.Completable
import io.reactivex.Single

class AmityUserNotification internal constructor() {

    @Deprecated(message = "This method is deprecated",
            replaceWith = ReplaceWith(expression = "enable() or disable()"),
            level = DeprecationLevel.WARNING)
    fun setAllowed(allowed: Boolean): Completable {
        return UpdateUserNotificationUseCase().execute(allowed).toV2()
    }

    @Deprecated(message = "This method is deprecated",
            replaceWith = ReplaceWith(expression = "getSettings()"),
            level = DeprecationLevel.WARNING)
    fun isAllowed(): Single<Boolean> {
        return GetUserNotificationUseCase().execute().map { it.isEnabled() }.toV2()
    }

    fun enable(moduleModifiers: List<AmityUserNotificationModule.MODIFIER>? = null): Completable {
        return UpdateUserNotificationUseCase().execute(true, moduleModifiers).toV2()
    }

    fun disable(): Completable {
        return UpdateUserNotificationUseCase().execute(false).toV2()
    }

    fun getSettings(): Single<AmityUserNotificationSettings> {
        return GetUserNotificationUseCase().execute().toV2()
    }

}