package com.amity.socialcloud.sdk.core.user

import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.core.permission.AmityRolesFilter


sealed class AmityUserNotificationModule(private val isEnabled: Boolean,
                                         private var rolesFilter: AmityRolesFilter) {

    fun isEnabled(): Boolean {
        return isEnabled
    }

    fun getRolesFilter(): AmityRolesFilter {
        return rolesFilter
    }

    class CHAT(isEnabled: Boolean,
               rolesFilter: AmityRolesFilter) : AmityUserNotificationModule(isEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityUserNotificationModuleName.CHAT, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityUserNotificationModuleName.CHAT, false)
            }
        }
    }

    class SOCIAL(isEnabled: Boolean,
                 rolesFilter: AmityRolesFilter) : AmityUserNotificationModule(isEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityUserNotificationModuleName.SOCIAL, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityUserNotificationModuleName.SOCIAL, false)
            }
        }
    }

    class VIDEO_STREAMING(isEnabled: Boolean,
                          rolesFilter: AmityRolesFilter) : AmityUserNotificationModule(isEnabled, rolesFilter) {

        companion object {
            fun enable(rolesFilter: AmityRolesFilter? = null): MODIFIER {
                return MODIFIER(AmityUserNotificationModuleName.VIDEO_STREAMING, true, rolesFilter)
            }

            fun disable(): MODIFIER {
                return MODIFIER(AmityUserNotificationModuleName.VIDEO_STREAMING, false)
            }
        }
    }


    class MODIFIER internal constructor(private val moduleName: AmityUserNotificationModuleName,
                                        private val isEnabled: Boolean,
                                        rolesFilter: AmityRolesFilter? = null) {

        private var includedRoles: AmityRoles? = null
        private var excludedRoles: AmityRoles? = null

        init {
            when (rolesFilter) {
                is AmityRolesFilter.ONLY -> {
                    this.includedRoles = rolesFilter.getRoles()
                }
                is AmityRolesFilter.NOT -> {
                    this.excludedRoles = rolesFilter.getRoles()
                }
                else -> {
                    this.includedRoles = AmityRoles()
                    //this.excludedRoles = EkoRoles()
                }
            }
        }

        internal fun getModuleName(): AmityUserNotificationModuleName {
            return moduleName
        }

        internal fun isEnabled(): Boolean {
            return isEnabled
        }

        internal fun getIncludedRoles(): AmityRoles? {
            return includedRoles
        }

        internal fun getExcludedRoles(): AmityRoles? {
            return excludedRoles
        }

    }

}