package com.amity.socialcloud.sdk.core.user

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.GetUserPagedListUseCase
import com.ekoapp.ekosdk.internal.usecase.user.GetUserPagingDataUseCase
import io.reactivex.Flowable

class AmityAllUsersQuery private constructor(private val sortOption: AmityUserSortOption, private val keyword: String?) {
    
    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityUser>> {
        return GetUserPagedListUseCase().execute(keyword = keyword, sortBy = sortOption)
    }

    fun getPagingData(): Flowable<PagingData<AmityUser>> {
        return GetUserPagingDataUseCase().execute(keyword = keyword, sortBy = sortOption).toV2()
    }

    class Builder internal constructor() {

        private var sortOption: AmityUserSortOption = AmityUserSortOption.DISPLAYNAME
        private var keyword: String? = null

        fun sortBy(sortOption: AmityUserSortOption): Builder {
            this.sortOption = sortOption
            return this
        }

        fun build(): AmityAllUsersQuery {
            return AmityAllUsersQuery(sortOption, keyword)
        }
    }
}