package com.amity.socialcloud.sdk.core.user

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.user.GetUserPagedListUseCase
import com.ekoapp.ekosdk.internal.usecase.user.GetUserPagingDataUseCase
import io.reactivex.Flowable


class AmityUserSearchByDisplayName private constructor(private val keyword: String?,
                                                       private val sortOption: AmityUserSortOption) {
    
    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityUser>> {
        return GetUserPagedListUseCase().execute(keyword, sortOption)
    }

    fun getPagingData(): Flowable<PagingData<AmityUser>> {
        return GetUserPagingDataUseCase().execute(keyword = keyword, sortBy = sortOption).toV2()
    }

    class Builder internal constructor() {
        private var keyword: String? = null
        private var sortOption: AmityUserSortOption = AmityUserSortOption.DISPLAYNAME

        internal fun keyword(keyword: String): Builder {
            this.keyword = keyword
            return this
        }

        fun sortBy(sortOption: AmityUserSortOption): Builder {
            this.sortOption = sortOption
            return this
        }

        fun build(): AmityUserSearchByDisplayName {
            return AmityUserSearchByDisplayName(keyword, sortOption)
        }
    }

}