package com.amity.socialcloud.sdk.core.user

import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.community.AmityQuerySortingOrder
import com.google.common.base.Objects

enum class AmityUserSortOption(val apiKey: String,
                               val sortingColumn: String,
                               val sortingOrder: String) {
    DISPLAYNAME("displayName", "user.displayName", AmityQuerySortingOrder.ASC.sqlOrder), FIRST_CREATED("firstCreated", "user.createdAt", AmityQuerySortingOrder.ASC.sqlOrder), LAST_CREATED("lastCreated", "user.createdAt", AmityQuerySortingOrder.DESC.sqlOrder);

    companion object {
        fun fromApiKey(apiKey: String?): AmityUserSortOption {
            for (filter in values()) {
                if (Objects.equal(apiKey, filter.apiKey)) {
                    return filter
                }
            }
            AmityLog.e(Exception(), "unknown api key : %s of user sort option", apiKey)
            return DISPLAYNAME
        }
    }
}