package com.amity.socialcloud.sdk.core.user

import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.repository.user.UserUpdateOption
import com.ekoapp.ekosdk.internal.usecase.user.UpdateUserUseCase
import com.google.gson.JsonObject
import io.reactivex.Single

class AmityUserUpdate internal constructor(private var userId: String, private var option: UserUpdateOption) {

    class Builder(private val userId: String) {
        private var displayName: String? = null
        private var roles: AmityRoles? = null
        private var permissions: AmityPermissions? = null
        private var metadata: JsonObject? = null
        private var avatarFileId: String? = null
        private var avatarCustomUrl: String? = null
        private var description: String? = null

        fun displayName(displayName: String): Builder {
            return apply { this.displayName = displayName }
        }

        private fun roles(roles: AmityRoles): Builder {
            return apply { this.roles = roles }
        }

        private fun permissions(permissions: AmityPermissions): Builder {
            return apply { this.permissions = permissions }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }

        fun avatarCustomUrl(avatarCustomUrl: String): Builder {
            return apply { this.avatarCustomUrl = avatarCustomUrl }
        }

        fun description(description: String): Builder {
            return apply { this.description = description }
        }

        fun build(): AmityUserUpdate {
            val option = UserUpdateOption(
                    displayName = displayName,
                    roles = roles,
                    permissions = permissions,
                    metadata = metadata,
                    avatarFileId = avatarFileId,
                    avatarCustomUrl = avatarCustomUrl,
                    description = description)

            return AmityUserUpdate(userId = userId, option = option)
        }
    }

    fun update(): Single<AmityUser> {
        return updateUser()
    }

    private fun updateUser(): Single<AmityUser> {
        return UpdateUserUseCase().execute(userId, option).toV2()
    }
}