package org.amity.diagnostics;

import android.util.Log;

import timber.log.Timber;

class TimberLogger implements Logger {

    private static final String TIMBER_FORMAT = "%s";
    private final String name;


    TimberLogger(String name) {
        this.name = name;
    }

    private Timber.Tree timber() {
        return Timber.tag(name);
    }

    private boolean isLoggable(int level) {
        return Log.isLoggable(name, level);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isTraceEnabled() {
        return isLoggable(Log.VERBOSE);
    }

    @Override
    public void trace(String msg) {
        timber().v(msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        timber().v(t, TIMBER_FORMAT, msg);
    }

    @Override
    public boolean isDebugEnabled() {
        return isLoggable(Log.DEBUG);
    }

    @Override
    public void debug(String msg) {
        timber().d(msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        timber().d(t, TIMBER_FORMAT, msg);
    }

    @Override
    public boolean isInfoEnabled() {
        return isLoggable(Log.INFO);
    }

    @Override
    public void info(String msg) {
        timber().i(msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        timber().i(t, TIMBER_FORMAT, msg);
    }

    @Override
    public boolean isWarnEnabled() {
        return isLoggable(Log.WARN);
    }

    @Override
    public void warn(String msg) {
        timber().w(msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        timber().w(t, TIMBER_FORMAT, msg);
    }

    @Override
    public boolean isErrorEnabled() {
        return isLoggable(Log.ERROR);
    }

    @Override
    public void error(String msg) {
        timber().e(msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        timber().e(t, TIMBER_FORMAT, msg);
    }
}
