package com.amity.socialcloud.sdk.core.data.user

import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.UserUpdateRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface UserApi {

    @GET("api/v3/users/{userId}")
    fun getUser(
        @Path("userId") userId: String? = null
    ): Single<EkoUserListDto>

    @GET("api/v3/users/list")
    fun getUserByIds(
        @Query("userIds[]") userIds: List<String>
    ): Single<EkoUserListDto>

    @PUT("api/v3/users")
    fun updateUser(
        @Body request: UserUpdateRequest
    ): Single<EkoUserListDto>

    @GET("api/v3/users")
    fun queryUsers(
        @Query("keyword") keyword: String? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<EkoUserListDto>

    @POST("api/v4/me/flags/{userId}")
    fun flagUser(
        @Path("userId") userId: String? = null
    ): Single<EkoUserListDto>

    @DELETE("api/v4/me/flags/{userId}")
    fun unflagUser(
        @Path("userId") userId: String? = null
    ): Single<EkoUserListDto>

    @GET("api/v3/users/{userId}/isFlagByMe")
    fun isFlaggedByMe(
        @Path("userId") userId: String? = null
    ): Single<JsonObject>
}