package com.amity.socialcloud.sdk.social.domain.storytarget.get

import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository
import com.amity.socialcloud.sdk.social.domain.storytarget.composer.StoryTargetComposerUseCase
import io.reactivex.rxjava3.core.Flowable


internal class GetStoryTargetsUseCase {

    fun execute(
        targets: List<Pair<AmityStory.TargetType, String>>
    ): Flowable<List<AmityStoryTarget>> {
        return StoryTargetRepository().getStoryTargets(targets)
            .map {
                it.map {
                    StoryTargetComposerUseCase().execute(it)
                }
            }
    }
}