package com.amity.socialcloud.sdk.core.session.component

import com.amity.socialcloud.sdk.core.domain.session.ClearDatabaseUseCase
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus
import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import io.reactivex.rxjava3.schedulers.Schedulers

class DatabaseSessionComponent(
    sessionLifeCycleEventBus: SessionLifeCycleEventBus,
    sessionStateEventBus: SessionStateEventBus
) :
    SessionComponent(
        sessionLifeCycleEventBus, sessionStateEventBus
    ) {
    override fun onSessionStateChange(sessionState: SessionState) {

    }

    override fun establish(account: EkoAccount) {
        //nothing
    }

    override fun destroy() {
        ClearDatabaseUseCase().execute().subscribeOn(Schedulers.io()).subscribe()
    }

    override fun handleTokenExpire() {
        ClearDatabaseUseCase().execute().subscribeOn(Schedulers.io()).subscribe()
    }
}