package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;

@Dao
public abstract class EkoSocketUrlDao {

    @Query("SELECT * from socket_url LIMIT 1")
    public abstract Flowable<EkoSocketUrl> getCurrentSocketUrlFlowable();

    @Query("SELECT * from socket_url LIMIT 1")
    public abstract Maybe<EkoSocketUrl> getCurrentSocketUrl();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insert(EkoSocketUrl url);
}
