package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.amity.socialcloud.sdk.social.data.story.StoryEventPersister
import com.amity.socialcloud.sdk.social.data.story.StoryLocalDataStore
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers


internal class StoryDeleted : StoryEventListner() {

    override fun getEventName(): String {
        return "story.deleted"
    }

    override fun processEvent(dto: StoryQueryDto) {
        val activeUser = SessionLocalDataStore().getActiveUserId()
        StoryEventPersister().persist(dto)
            .andThen(
                Flowable.fromIterable(
                    dto.stories?.filter { it.creatorPublicId != activeUser } ?: emptyList()
                )
                    .flatMapCompletable {
                        StoryLocalDataStore()
                            .deleteStory(it.storyId ?: "")
                            .onErrorComplete()
                    }
            )
            .subscribeOn(Schedulers.io())
            .subscribe()
    }

}