package com.ekoapp.ekosdk;

import androidx.annotation.NonNull;

import com.google.common.base.Objects;

public enum EkoChannelReadStatus {

    READING("reading"),
    NOT_READING("not_reading"),
    UNKNOWN("unknown");

    @NonNull
    private final String apiKey;

    EkoChannelReadStatus(@NonNull String apiKey) {
        this.apiKey = apiKey;
    }

    @NonNull
    public String getApiKey() {
        return apiKey;
    }

    public static EkoChannelReadStatus fromApiKey(@NonNull String apiKey) {
        if (Objects.equal(READING.apiKey, apiKey)) {
            return READING;
        } else if (Objects.equal(NOT_READING.apiKey, apiKey)) {
            return NOT_READING;
        }
        return UNKNOWN;
    }
}
